<?php 
include ('includes/header.php');
include ('includes/generate_portals.php');

//table name
$table_name = "dns";
$page = "main.php";

//table call
$res = $db->select($table_name, '*', '', '');

//update call
@$resU = $db->select($table_name, '*', 'id = :id', '', [':id' => $_GET['update']]);

/* =========================
   UPDATE
========================= */
if(isset($_POST['submitU'])){
    unset($_POST['submitU']);
    $updateData = $_POST;
    $db->update($table_name, $updateData, 'id = :id',[':id' => $_GET['update']]);
    generatePortalsJSON($db);
    echo "<script>window.location.href='".$page."?status=1'</script>";
}

/* =========================
   INSERT
========================= */
if (isset($_POST['submit'])){
    unset($_POST['submit']);
    $db->insert($table_name, $_POST);
    generatePortalsJSON($db);
    $db->close();
    echo "<script>window.location.href='".$page."?status=1'</script>";
}

/* =========================
   DELETE
========================= */
if(isset($_GET['delete'])){
    $db->delete($table_name, 'id = :id',[':id' => $_GET['delete']]);
    generatePortalsJSON($db);
    echo "<script>window.location.href='".$page."?status=2'</script>";
}
?>

<div class="modal fade" id="confirm-delete" tabindex="-1" role="dialog">
	<div class="modal-dialog">
		<div class="modal-content" style="background-color: black;">
			<div class="modal-header">
				<h2 style="color: white;">Confirm</h2>
			</div>
			<div class="modal-body" style="color: white;">
				Do you really want to delete?
			</div>
			<div class="modal-footer">
				<button type="button" class="btn btn-primary" data-dismiss="modal">Cancel</button>
				<a style="color: white;" class="btn btn-danger btn-ok">Delete</a>
			</div>
		</div>
	</div>
</div>

<?php
/* =========================
   CREATE FORM
========================= */
if (isset($_GET['create'])){
?>

<div class="col-md-12 mx-auto ctmain-table">
	<div class="card-body">
		<div class="card ctcard">
			<div class="card-header card-header-warning">
				<center>
					<h2><i class="icon icon-bullhorn"></i> DNS & Username Input</h2>
				</center>
			</div>
			<div class="card-body">
				<div class="col-12">
					<h3>Add DNS</h3>
				</div>
				<form method="post">
					<div class="form-group ctinput">
						<label>Title</label>
						<input class="form-control" name="title" placeholder="Title" required>
					</div>
					<div class="form-group ctinput">
						<label>DNS</label>
						<input class="form-control" name="url" placeholder="http://server:port" required>
					</div>
					<div class="form-group ctinput">
						<center>
							<button class="btn btn-info" name="submit">
								<i class="icon icon-check"></i> Submit
							</button>
						</center>
					</div>
				</form>
			</div>
		</div>
	</div>
</div>

<?php
/* =========================
   UPDATE FORM
========================= */
}else if (isset($_GET['update'])){ 
?>

<div class="col-md-12 mx-auto ctmain-table">
	<div class="card-body">
		<div class="card ctcard">
			<div class="card-header card-header-warning">
				<center>
					<h2><i class="icon icon-bullhorn"></i> Edit DNS</h2>
				</center>
			</div>
			<div class="card-body">
				<form method="post">
					<input type="hidden" name="id" value="<?=$_GET['update'] ?>">
					<div class="form-group ctinput">
						<label>Title</label>
						<input class="form-control" name="title" value="<?=$resU[0]['title']?>" required>
					</div>
					<div class="form-group ctinput">
						<label>DNS</label>
						<input class="form-control" name="url" value="<?=$resU[0]['url']?>" required>
					</div>
					<div class="form-group ctinput">
						<center>
							<button class="btn btn-info" name="submitU">
								<i class="icon icon-check"></i> Update
							</button>
						</center>
					</div>
				</form>
			</div>
		</div>
	</div>
</div>

<?php
/* =========================
   MAIN TABLE
========================= */
}else{
?>

<div class="col-md-12 mx-auto ctmain-table">
	<div class="card-body">
		<div class="card ctcard">
			<div class="card-header card-header-warning">
				<center>
					<h2><i class="icon icon-commenting"></i> Current DNSs</h2>
				</center>
			</div>
			<div class="card-body">
				<center>
					<a href="<?=$page?>?create" class="btn btn-info">New DNS</a>
				</center>
				<br>
				<div class="table-responsive">
					<table class="table table-striped table-sm">
						<thead style="color:white">
							<tr>
								<th>Title</th>
								<th>DNS</th>
								<th>Actions</th>
							</tr>
						</thead>
						<tbody>
						<?php foreach ($res as $row){ ?>
							<tr>
								<td><?=$row['title']?></td>
								<td><?=$row['url']?></td>
								<td>
									<a class="btn btn-info" href="<?=$page?>?update=<?=$row['id']?>"><i class="fa fa-pencil"></i></a>
									<a class="btn btn-danger" href="#" data-href="<?=$page?>?delete=<?=$row['id']?>" data-toggle="modal" data-target="#confirm-delete"><i class="fa fa-trash"></i></a>
								</td>
							</tr>
						<?php } ?>
						</tbody>
					</table>
				</div>
			</div>
		</div>
	</div>
</div>

<?php } ?>

<?php include ('includes/footer.php'); ?>
</body>
</html>
